Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.SqlClient


Public Class ResourceDB

#Region "Metody"


    ''' <summary>
    ''' Zapisuje <see cref="Resource" /> w bazie danych
    ''' </summary>
    ''' <param name="filename">Nazwa pliku zasobu.</param>
    ''' <param name="fromContactEmail">E-mail nadawcy zasobu.</param>
    ''' <param name="message">Wiadomo wysyana razem z zasobem.</param>
    ''' <param name="toContactEmail">E-mail odbiorcy.</param>
    ''' <param name="ID">Opcjonalny parametr: identyfikator zasobu.</param>
    Public Shared Function SaveResource(ByVal filename As String, ByVal fromContactEmail As String, ByVal toContactEmail As String, ByVal message As String, Optional ByVal ID As Integer = Nothing) As Integer
        Using mConnection As New SqlConnection(Config.ConnectionString)

            Dim mResourceID As Integer

            'Utwrz obiekt SqlCommand
            Dim mCommand As SqlCommand = New SqlCommand("sprocResourceInsertUpdateItem", mConnection)

            'ustaw jego typ na "procedur skadowan"
            mCommand.CommandType = CommandType.StoredProcedure

            'dodaj parametry
            If ID > 0 Then
                mCommand.Parameters.AddWithValue("@id", ID)
            Else
                mCommand.Parameters.AddWithValue("@id", DBNull.Value)
            End If
            mCommand.Parameters.AddWithValue("@filename", filename)
            mCommand.Parameters.AddWithValue("@fromContactEmail", fromContactEmail)
            mCommand.Parameters.AddWithValue("@toContactEmail", toContactEmail)
            mCommand.Parameters.AddWithValue("@message", message)

            'otwrz poaczenie i wykonaj procedur skadowan
            mConnection.Open()
            mResourceID = mCommand.ExecuteScalar()
            mConnection.Close()

            Return mResourceID

        End Using

    End Function


    ''' <summary>
    ''' Zwraca nazw pliku z klasy <see cref="Resource" /> po przesaniu identyfikatora zasobu
    ''' </summary>
    ''' <param name="id">Identyfikator zasobu.</param>
    Public Shared Function GetResourceFileName(ByVal id As Integer) As String
        Dim filename As String
        Try
            Using mConnection As New SqlConnection(Config.ConnectionString)
                Dim mCommand As SqlCommand = New SqlCommand("sprocResourceSelectSingleItem", mConnection)
                mCommand.CommandType = CommandType.StoredProcedure
                mCommand.Parameters.AddWithValue("@id", id)
                mConnection.Open()
                Using mDataReader As SqlDataReader = mCommand.ExecuteReader(CommandBehavior.CloseConnection)
                    If mDataReader.Read() Then
                        filename = mDataReader.GetString(mDataReader.GetOrdinal("filename"))
                    End If
                    mDataReader.Close()
                End Using
            End Using
        Catch ex As Exception
            'Wywoujc wyraenie "Throw", przekazujemy informacje o bdzie do
            'pliku global.asax, ktry wywoa domyln stron obsugi bdw w celu 
            'przetworzenia i wywietlenia uytkownikowi zdefiniowanego przez nas komunikatu o bdzie
            Throw
        End Try
        Return filename
    End Function

    ''' <summary>
    ''' Zwraca tre HTML wiadomoci pocztowej do wysania
    ''' </summary>
    ''' <param name="msg">Dodatkowa wiadomo dostarczona
    ''' przez uytkownika, ktra bdzie zawarta w treci e-maila.</param>
    Public Shared Function GetEmailBody(ByVal msg As String, _
        ByVal id As Integer, ByVal SenderEmail As String, _
        ByVal RecipientEmail As String) As String
        Dim emailBody As String = ""
        Try
            Using mConnection As New SqlConnection(Config.ConnectionString)

                Dim mLink As String
                mLink = Config.httpDownloadPath & "Download.aspx?resourceID="

                Dim mCommand As SqlCommand = New _
                    SqlCommand("sprocEmailSelectSingleItem", mConnection)
                mCommand.CommandType = CommandType.StoredProcedure
                mConnection.Open()
                Using mDataReader As SqlDataReader = _
                    mCommand.ExecuteReader(CommandBehavior.CloseConnection)
                    If mDataReader.Read() Then
                        'pobierz szablonow zawarto e-maila z tabeli email
                        emailBody = mDataReader.GetString( _
                            mDataReader.GetOrdinal(Config.EmailFormatSelected))
                        'zastp obszar msg wiadomoci od nadawcy
                        emailBody = emailBody.Replace("[msg]", msg)
                        emailBody = emailBody.Replace("[link]", mLink & id.ToString())
                        emailBody = emailBody.Replace("[sender]", SenderEmail)
                        emailBody = emailBody.Replace("[recipient]", RecipientEmail)

                    End If
                    mDataReader.Close()
                End Using
            End Using
        Catch ex As Exception
            'Wywoujc wyraenie "Throw", przekazujemy informacje o bdzie do
            'pliku global.asax, ktry wywoa domyln stron obsugi bdw w celu 
            'przetworzenia i wywietlenia uytkownikowi zdefiniowanego przez nas komunikatu o bdzie
            Throw
        End Try
        Return emailBody
    End Function


#End Region



End Class
